IF EXISTS
(
	SELECT *
	FROM sys.triggers
	WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_NF_SAI_IT_ULT_MOV]')
)
	DROP TRIGGER [dbo].[TRG_EST_NF_SAI_IT_ULT_MOV];
 GO

CREATE TRIGGER [dbo].[TRG_EST_NF_SAI_IT_ULT_MOV] ON [dbo].[EST_NF_SAI_IT]
FOR  UPDATE 

/*
=======================================================================================
'Job.................:  
'Função..............: 
'Objetivo............: Incluir periodo da emissão da nota na pendencia, para que a rotina P_EST_PROD_VD_PROC_ALL reprocesse o periodo. 
'Tabelas.............: EST_NF_SAI_IT | EST_PROD_CPL_VD_LOTE_PROC_PENDENTE | EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL |  EST_PROD_CPL_VD_LOTE_PROC_EST_PROD
'Dt Modificação......: 20/11/2020
'Modificação.........: Toda alteração no item deve refletir nos relatório de movimento de venda  
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 

*/
AS
BEGIN 
	DECLARE @CD_CTR_MOVIMENTO INT
	DECLARE @RSPROD TABLE (CD_EMP INT,
						   CD_FILIAL INT,
						   CD_CTR_DT_MOVIMENTO INT,
						   CD_PROD INT)

-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

	INSERT INTO @RSPROD
	SELECT
		INSERTED.CD_EMP,
		INSERTED.CD_FILIAL,
		GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO,
		INSERTED.CD_PROD
	FROM
		INSERTED 
		INNER JOIN EST_NF_SAI_VENDAS ON INSERTED.CD_EMP    = EST_NF_SAI_VENDAS.CD_EMP
									AND INSERTED.CD_FILIAL = EST_NF_SAI_VENDAS.CD_FILIAL
									AND INSERTED.CD_NF     = EST_NF_SAI_VENDAS.CD_NF
		INNER JOIN GLB_DT_MOVIMENTO ON INSERTED.DT_EMI_NF = GLB_DT_MOVIMENTO.DT_MOVIMENTO
 
 

-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	
	IF NOT EXISTS (SELECT *  FROM @RSPROD)
	RETURN;

	
-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	SET @CD_CTR_MOVIMENTO=ISNULL((SELECT TOP 1 CD_CTR_DT_MOVIMENTO FROM @RSPROD),0)
 
	DECLARE @CD_CTR INT	

	INSERT INTO EST_PROD_CPL_VD_LOTE_PROC_PENDENTE (CD_CTR_DT_MOVIMENTO,DT_CAD,ANO,MES,ANO_MES,ROTINA)
	SELECT DISTINCT 
		   GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO,
		   GETDATE(),
		   GLB_DT_MOVIMENTO.ANO_MOVIMENTO,
		   GLB_DT_MOVIMENTO.MES_MOVIMENTO,
		   GLB_DT_MOVIMENTO.ANO_MES_MOVIMENTO,
		   OBJECT_NAME(@@PROCID)
	  FROM GLB_DT_MOVIMENTO  
	 WHERE GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO = @CD_CTR_MOVIMENTO
	
	SET @CD_CTR=IDENT_CURRENT('EST_PROD_CPL_VD_LOTE_PROC_PENDENTE')


	INSERT INTO EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL (CD_CTR, CD_EMP, CD_FILIAL )
	SELECT DISTINCT 
		   @CD_CTR,
		   I.CD_EMP,
		   I.CD_FILIAL
	  FROM INSERTED I 
		   LEFT OUTER JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL ON I.CD_EMP    = EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_EMP 
															   AND I.CD_FILIAL = EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_FILIAL 
															   AND @CD_CTR     = EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_CTR
     WHERE EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_FILIAL IS NULL



	 INSERT INTO EST_PROD_CPL_VD_LOTE_PROC_EST_PROD (CD_CTR,CD_EMP,CD_PROD)
	 SELECT DISTINCT 
	        @CD_CTR,
			I.CD_EMP,
			I.CD_PROD
	   FROM @RsProd I	
			LEFT OUTER JOIN EST_PROD_CPL_VD_LOTE_PROC_EST_PROD ON I.CD_EMP   = EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_EMP 
															  AND I.CD_PROD  = EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_PROD  
															  AND @CD_CTR    = EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_CTR
			 WHERE EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_PROD IS NULL
	  
END;  